﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Get Appointment step.
    /// </summary>
    public class GetAppointmentStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            if (!state.IsGroupAppointment) return;

            if (!state.OutboundRequestMessage.AppointmentId.HasValue) throw new Exception("$Group Appointment must have an AppointmentId");

            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                state.Appointment = srv.AppointmentSet.FirstOrDefault(x => x.Id == state.OutboundRequestMessage.AppointmentId.Value);
                if (state.Appointment == null) throw new Exception($"Cannot find Appointment for Service Appointment: {state.OutboundRequestMessage.AppointmentId.Value} required for a Group Appointment");
            }
        }
    }
}